/* __________________________________________________________________________
   ¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯ 
   1 ** -- variable at the ZE x APE level 
   __________________________________________________________________________
   ¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯ */ 

des using "${tmp}/total_patent_ZE_ape.dta"

** -- of variable to be summarized
global dvlist ln_eng_sbrut ln_eng_hrwg ln_eng_hrs newempnolarge newempnolarge_newsiren newempnolarge_oldsiren share_new_ing pat_nonorm tot_claims tot_nplcits tot_patcits  ///
	has_newcifre has_jeu has_soustrai ln_soustrait_pub	has_transfer_senior has_transfer_junior has_transfer_res has_jdoc 

	local sampeng 1
	global sampeng `sampeng'
			
	global cond_candi NAF_labex_candidate == 1 & ZE_labex_candidate == 1
	global cond_accept NAF_labex_accept == 1 & ZE_labex_accept == 1

	global sample_select inrange(year,2004,2019)
	use if $sample_select using "${tmp}/Regfile_nafZE", clear
	
	** -- rename variable to be consistent with labeling below
	rename ln_soustrait ln_soustrait_pub	
	
	rename mobsen has_transfer_senior 
	rename mobjun has_transfer_junior
	rename mobres has_transfer_res
	
	** -- add patent variables
	merge 1:1 ZE2010 ape year using "${tmp}/total_patent_ZE_ape.dta", keep(1 3) gen(_mtrial)

	gen wagebill_eng = job_eng_sbrut /1e6
	gen ln_job_eng_sbrut = ln(job_eng_sbrut)

	egen tot_hrs = rowtotal(job_eng_hrs job_tech_hrs job_hskill_noneng_hrs other_hrs)

	** -- generate dummy if gp is in baseline estimation sample
	reghdfe ln_job_eng_sbrut E_????  if $cond_accept, a(ZE2010#year gp)  cl(gp)
	bys gp: egen insampeng = max(e(sample))

	if $sampeng == 1 {
		keep if insampeng == 1
	}

	keep if year<=2010 // & year>=2009
	tab year
		
	gen job_tot_fte 	= tot_hrs  	/ (151*12)
	gen job_eng_fte 	= job_eng_hrs  	/ (151*12)
	*gen nbheur_tot_rd20_fte = nbheur_tot_rd20 	/ (151*12)

	recode nb_siren* job_tot_fte job_eng_fte pat_nonorm tot_nplcits tot_patcits (.=0)

	bys gp: egen dum_pubtopri = sum(nbheur_seniorrespubtopri > 0  & inrange(year,2009,2010) & !mi(nbheur_seniorrespubtopri))
	replace dum_pubtopri = dum_pubtopri >0


	gstats sum exposure if $cond_candi & exposure<1e+9, d

	* exposure 
	gen ln1exposure = ln(exposure+1)
    replace ln1exposure = 0 if mi(ln1exposure)

	* amount of indidrect subsidy in million
	replace exposure = exposure / 1e+6
	
	** -- additional channels variables
	gen has_newcifre = (nb_newcifre>0) & !mi(nb_newcifre)
	replace newempnolarge = newempnolarge_newsiren+newempnolarge_oldsiren

	** -- label variables 
	label var job_tot_fte 					"Total employment"
	label var wagebill_eng 					"Engineer wage bill (in millions euros)"
	label var job_eng_fte 					"Engineer employment"
	label var ln_job_eng_sbrut				"Log Engineer wage bill (in euros)"
	*label var nbheur_tot_rd20_fte			"Employment in R\&D intensive plants"
	*label var creance_split				"R\&D tax credit claims (in millions euros)"
	label var newempnolarge					"Plant creation rate"
	label var newempnolarge_newsiren		"Plant creation rate (by new firms)"
	label var newempnolarge_oldsiren		"Plant creation rate (by existing firms)"
	label var share_new_ing					"Engineering plant creation rate"
	label var pat_nonorm					"\# EPO patents"
	label var tot_nplcits					"\# Citations to science in patents"
	label var tot_patcits					"\# Patent citations received"
	label var has_soustrai			 		"Outsource R\&D to public sector"
	label var has_newcifre 					"Has a industry-univ. PhD convention"		
	label var dum_pubtopri  				"Transfer from univ to private"
	label var has_jdoc  					"Employs a young doctor"
	label var exposure						" Exposure (in millions euros)"
	label var ln1exposure					" $ \ln(\text{expo}_{ik} +1) $ "
	label var prox							" Proximity"

	global lvar_zenaf ln_eng_sbrut ln_eng_hrwg ln_eng_hrs job_eng_fte newempnolarge newempnolarge_newsiren newempnolarge_oldsiren share_new_ing pat_nonorm tot_claims tot_nplcits tot_patcits  ///
	has_newcifre has_jeu has_soustrai ln_soustrait_pub	has_transfer_senior has_transfer_junior has_transfer_res has_jdoc 
	
	foreach var of global lvar_zenaf {
		local lab: variable label `var'
		*replace name = "`lab'" if var == "`var'"
		dis "`var': `lab'"
	} 

	global lvar_zenaf exposure ln1exposure prox job_tot_fte job_eng_fte wagebill_eng ln_job_eng_sbrut creance_split pat_nonorm has_soustrai has_newcifre has_jeu has_jdoc dum_pubtopri nb_siren nb_siren_eng
	
	* 
	global lvar_zenaf exposure ln1exposure prox job_tot_fte job_eng_fte wagebill_eng ln_eng_sbrut ln_eng_hrwg ln_eng_hrs newempnolarge newempnolarge_newsiren newempnolarge_oldsiren share_new_ing pat_nonorm tot_claims tot_nplcits tot_patcits  ///
	has_newcifre has_jeu has_soustrai ln_soustrait_pub	has_transfer_senior has_transfer_junior has_transfer_res has_jdoc 



	global mean 
	foreach v in $lvar_zenaf {
		global mean $mean m_`v' = `v'
	}

	global stat_list sd p50 p90 

	foreach stat in $stat_list {
		global `stat'
		foreach v in $lvar_zenaf {
			global `stat'  $`stat' `stat'_`v' = `v'
		}
	}

	global cmd_allstat (mean) $mean
	foreach stat in $stat_list {
		global cmd_allstat $cmd_allstat (`stat') ${`stat'}
	}

	macro list cmd_allstat

	cd "$tmp"
	*preserve 


	bys gp: gen distinct_gp = _n==1
	
	gen tercile = HEtop_2009*3 + HEmid_2009*2 + (HEmid_2009+HEtop_2009==0) if year == 2009
	bys gp (tercile): replace tercile= tercile[1]

	keep if $cond_accept & insampeng

	** -- patent variables on claims are set to 0 when missing
	recode tot_claims tot_nplcits tot_patcits  (.=0)
	
	** -- some variables are not defined prior to 2010, so we only present descriptive statistics for 2010
	replace has_newcifre = . if year<=2009
	replace has_jeu = . if year<=2009
	replace has_soustrai = . if year<=2009
	replace ln_soustrait_pub = . if year<=2009
	
	replace has_transfer_senior =. if year<=2009
	replace has_transfer_junior =. if year<=2009
	replace has_transfer_res =. if year<=2009
	replace has_jdoc =. if year<=2009
	
	
	gcollapse $cmd_allstat (sum) distinct_gp (count) N = gp if $cond_candi, by(tercile)
	gen sample = 2

	save stat_all_tercile, replace

	use stat_all_tercile, clear
	gen n = 1
	
	reshape long m_ p50_ p90_ sd_ , i(tercile) j(var) string
	
	bys tercile: replace n = _n
	reshape wide m_* p50_* p90_* sd_* N distinct_gp, i(n) j(tercile)
	order var
	drop sample

	gen name = ""
	
	replace name = "Total employment" 							if var== "job_tot_fte" 					
	replace name = "Engineer wage bill (in millions euros)" 	if var== "wagebill_eng" 				
	replace name = "Engineer employment" 						if var== "job_eng_fte"					
	replace name = "Log Engineer wage bill (in euros)"	 		if var== "ln_job_eng_sbrut"				
	replace name = "Employment in R\&D intensive plants" 		if var== "nbheur_tot_rd20_fte"			
	replace name = "R\&D tax credit claims (in millions euros)" if var== "creance_split"				
	replace name = "Outsource R\&D to public sector" 			if var== "has_soustrai"			 	
	replace name = "Has a industry-univ. PhD convention"		if var== "has_newcifre" 				
	replace name = "\# EPO patents" 							if var== "pat_nonorm"					
	replace name = "Transfer from univ to private" 				if var== "dum_pubtopri"  				
	replace name = "\# plants" 									if var== "nb_siren" 					
	replace name = "\# plants employing engineers" 				if var== "nb_siren_eng"					
	*replace name =  											if var== "exposure"						
	replace name = " $ \text{expo}_{ik}  $ " 					if var== "ln1exposure"					
	replace name = "Proximity" 									if var== "prox"							
	replace name = "Has PhD graduate in priv. sector"			if var == "has_jdoc"
	replace name = "Has academic spin-off"                      if var == "has_jeu"	
	
	
	replace name = "Indirect subsidy (in millions euros)"			if var == "exposure"
	replace name = "Exposure"										if var == "ln1exposure"						// $ \text{expo}_{ik}
	replace name = "Proximity"										if var == "prox"
	replace name = "R\&D wage bill (log)"							if var == "ln_eng_sbrut"
	replace name = "Log R\&D hourly wage (log)"						if var == "ln_eng_hrwg"
	replace name = "Log R\&D hours (log)"							if var == "ln_eng_hrs"
	replace name = "Log value of RTC "								if var == "ln_cirtot"
	replace name = "Entry of new plants (binary)"					if var == "has_entry"
	replace name = "Entry of new plants by new firms"				if var == "has_entry_new_siren"
	replace name = "Entry of new plants by pre-existing firms"		if var == "has_entry_old_siren"
	replace name = "\# patents"								if var == "pat"
	replace name = "PhD cosupervision"								if var == "has_newcifre"
	replace name = "Academic spin-off (binary)"                     if var == "has_jeu"	
	replace name = "Outsourcing R\&D to public labs (binary)"		if var == "has_soustrai"
	replace name = "Engineering plant creation rate"				if var == "share_new_ing"

	replace name = "Outsourcing R\&D to public labs (log)"				if var == "ln_soustrait_pub"
	replace name = "Tranfer of senior academics (binary)"				if var == "has_transfer_senior"
	replace name = "Tranfer of junior academics (binary)"				if var == "has_transfer_junior"
	replace name = "Tranfer of researchers (binary)"					if var == "has_transfer_res"
	replace name = "Hiring of young PhDs (binary)"						if var == "has_jdoc"

	replace name = "Raw patent count (weighted by claims)"							if var == "tot_claims"
	replace name = "Av. backward citations to science"					if var == "mean_nplcits"
	replace name = "Av. pat. citations received"						if var == "mean_patcits"
	replace name = "R\&D wagebill in firms $ \leq $ 5 yr"				if var == "ln_eng_sbrut_yg5y"
	replace name = "TFP (log)"											if var == "tfp_net"
	
	replace name = "Plant creation rate" 						if var == "newempnolarge"
	replace name = "Plant creation rate (by new firms)" 		if var == "newempnolarge_newsiren" 
	replace name = "Plant creation rate (by existing firms)" 	if var == "newempnolarge_oldsiren" 
	replace name = "\# patents weighted by NPL cit." 			if var == "tot_nplcits"
	replace name = "\# patent citations" 						if var == "tot_patcits" 
	
	replace name = "Connection to science adjusted patent count"		 			if var == "tot_nplcits"
	replace name = "Forward citations adjusted patent count" 						if var == "tot_patcits" 
	
		
	gen rkvar = . 
	local cnt = 0
	foreach v in $lvar_zenaf {
		local cnt `++cnt'
		dis "`cnt'"
		replace rkvar = `cnt' if var == "`v'"
		
	}
	
	sort rkvar
	
	global gp1 if inlist(var,"prox","exposure","ln1exposure") | inlist(var,"job_eng_fte","wagebill_eng","ln_eng_sbrut","ln_eng_hrwg","ln_eng_hrs")
	
	global gp2 if inlist(var,"tot_claims","tot_nplcits","tot_patcits") 
	
	global gp3 if inlist(var,"has_newcifre","has_jeu","has_soustrai","ln_soustrait_pub") | inlist(var,"has_transfer_senior","has_transfer_junior","has_transfer_res","has_jdoc") | inlist(var,"newempnolarge","newempnolarge_newsiren","newempnolarge_oldsiren","share_new_ing")
	
	
	format m_1 sd_1 m_2 sd_2 m_3 sd_3  %9.2f
	*& & \multicolumn{1}{c}{Mean} & \multicolumn{1}{c}{p50} & \multicolumn{1}{c}{p90} \\
	listtex name m_1 sd_1 m_2 sd_2 m_3 sd_3 using "$outpath/TableA2.tex" $gp1 , type rstyle(tabular) head("\begin{tabular}{lrrrrrrrr}\toprule" ///
	`"Variable & \multicolumn{2}{l}{Bottom tercile} & \multicolumn{2}{l}{Middle tercile} & \multicolumn{2}{l}{Top tercile} \\"' ///
	 `" \multicolumn{1}{l}{\textbf{\textit{R\&D and exposure variables}}}   & mean & sd &mean & sd & mean & sd  \\"' /// 
	`"\cmidrule(lr){1-1} \cmidrule(lr){2-3} \cmidrule(lr){4-5} \cmidrule(lr){6-7} "') ///
	replace
	
	listtex name m_1 sd_1 m_2 sd_2 m_3 sd_3  $gp2 , type rstyle(tabular) ///
	head(`" \midrule \multicolumn{1}{l}{\textbf{\textit{Output variables}}}   & mean & sd &mean & sd & mean & sd \\"' /// 
	`"\cmidrule(lr){1-1} \cmidrule(lr){2-3} \cmidrule(lr){4-5} \cmidrule(lr){6-7} "') ///
	appendto("$outpath/TableA2.tex") 
	
	listtex name m_1 sd_1 m_2 sd_2 m_3 sd_3  $gp3 , type rstyle(tabular) ///
	head(`" \midrule \multicolumn{1}{l}{\textbf{\textit{Channels}}}   & mean & sd &mean & sd & mean & sd  \\"' /// 
	`"\cmidrule(lr){1-1} \cmidrule(lr){2-3} \cmidrule(lr){4-5} \cmidrule(lr){6-7} "') ///
	appendto("$outpath/TableA2.tex")  foot("\bottomrule\end{tabular}") 
	


